/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.remote.common.ConfPlanByteHolder;
import cz.insophy.inplan.remote.common.ConfPlanMessageConverter;
import cz.insophy.inplan.remote.common.ExportException;
import cz.insophy.inplan.remote.common.ExportResult;
import cz.insophy.inplan.remote.common.ImportException;
import cz.insophy.inplan.remote.common.SerializingMessageConverter;
import cz.insophy.inplan.remote.common.SuperplanDescriptorDataHolder;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.ApplicationProperties;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.xml.ShopSerializer;
import cz.insophy.inplan.xml.SuperplanSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ServerManager {
    private static final Logger log = LoggerFactory.getLogger(ServerManager.class);
    private static final RestTemplate REST = new RestTemplate();
    private static final String PROXY_USER_PROPERTY = "proxy.user";
    private static final String PROXY_PASSWORD_PROPERTY = "proxy.password";
    private static RequestFactoryConfigurator requestFactoryConfigurator = new RequestFactoryConfigurator();

    public static Boolean checkAccess() {
        try {
            ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/check-access"), Object.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                return true;
            }
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.FORBIDDEN) {
                return false;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static byte[] loadLatestShopConf() throws ImportException {
        try {
            ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/latest-configuration"), byte[].class, new Object[0]);
            return (byte[])response.getBody();
        }
        catch (ResourceAccessException x) {
            log.error(x.getMessage(), x);
            if (x.getCause() != null) {
                throw new ImportException(x.getCause().getMessage(), x);
            }
            throw new ImportException(x.getMessage(), x);
        }
    }

    public static byte[] loadLatestSuperplan() throws ImportException {
        try {
            ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/latest-plan"), byte[].class, new Object[0]);
            return (byte[])response.getBody();
        }
        catch (ResourceAccessException x) {
            log.error(x.getMessage(), x);
            if (x.getCause() != null) {
                throw new ImportException(x.getCause().getMessage(), x);
            }
            throw new ImportException(x.getMessage(), x);
        }
    }

    public static long getLatestSuperplanRevision() throws ImportException {
        ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/latest-plan-revision"), Serializable.class, new Object[0]);
        try {
            return ServerManager.readObjectFromResponse((ResponseEntity<? extends Serializable>)response, Long.class);
        }
        catch (Exception x) {
            log.error(x.getMessage(), x);
            throw new ImportException(x.getMessage(), x);
        }
    }

    public static String getServerName() throws ImportException {
        ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/server-name"), byte[].class, new Object[0]);
        try {
            return ServerManager.readStringFromResponse((ResponseEntity<byte[]>)response);
        }
        catch (Exception x) {
            log.error(x.getMessage(), x);
            throw new ImportException(x.getMessage(), x);
        }
    }

    public static List<String> getUserRoles() throws HttpClientErrorException, HttpHostConnectException {
        try {
            ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/roles"), Serializable.class, new Object[0]);
            return Collections3.safeCast(ServerManager.readObjectFromResponse((ResponseEntity<? extends Serializable>)response, List.class), String.class);
        }
        catch (HttpClientErrorException e) {
            throw e;
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof HttpHostConnectException) {
                throw (HttpHostConnectException)e.getCause();
            }
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static List<SuperplanDescriptorDataHolder> getRevisions() throws HttpClientErrorException, HttpHostConnectException {
        try {
            ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/revisions"), Serializable.class, new Object[0]);
            return Collections3.safeCast(ServerManager.readObjectFromResponse((ResponseEntity<? extends Serializable>)response, List.class), SuperplanDescriptorDataHolder.class);
        }
        catch (HttpClientErrorException e) {
            throw e;
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof HttpHostConnectException) {
                throw (HttpHostConnectException)e.getCause();
            }
            throw new IllegalStateException(e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] getZippedRevision(long revision, int variant) throws HttpClientErrorException, HttpHostConnectException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("revision", Long.toString(revision));
        params.put("variant", Integer.toString(variant));
        ResponseEntity response = REST.getForEntity(ServerManager.createApiUrl("/historical-plan/revision/{revision}?variant={variant}"), byte[].class, params);
        try {
            return ServerManager.readObjectFromResponse((ResponseEntity<? extends Serializable>)response, byte[].class);
        }
        catch (Exception e) {
            log.error("Error reading http response for zipped revision " + revision);
            return null;
        }
    }

    public static byte[] getLatestConfPlanZip() throws ImportException, HttpHostConnectException {
        long rev = ServerManager.getLatestSuperplanRevision();
        return ServerManager.getZippedRevision(rev, 0);
    }

    @Nullable
    public static byte[] getPlugins(@Nonnull String kind) {
        try {
            ResponseEntity resp = REST.getForEntity(ServerManager.createApiUrl("/plugins/{kind}".replace("{kind}", kind)), byte[].class, Collections.emptyMap());
            return (byte[])resp.getBody();
        }
        catch (Exception e) {
            log.warn("Cannot get {} plugins from the server. {}", (Object)kind, (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static byte[] getUserSettings() {
        try {
            ResponseEntity resp = REST.getForEntity(ServerManager.createApiUrl("/ui-user-settings"), byte[].class, Collections.emptyMap());
            return (byte[])resp.getBody();
        }
        catch (Exception e) {
            log.warn("Cannot get user settings from the server. {}", (Object)e.getMessage());
            return null;
        }
    }

    public static ExportResult export(Superplan superplan, boolean force) throws ExportException {
        try {
            log.debug("Storing entities as XML array...");
            byte[] confXml = ShopSerializer.storeToXmlBytes(superplan.getShopConf());
            byte[] planXml = SuperplanSerializer.storeToXmlBytes(superplan);
            log.debug("Configuration length = {}, plan length = {}.", (Object)confXml.length, (Object)planXml.length);
            ConfPlanByteHolder holder = new ConfPlanByteHolder(confXml, planXml);
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("force", force);
            ResponseEntity response = REST.postForEntity(ServerManager.createApiUrl("/export/{force}"), (Object)holder, Serializable.class, params);
            ExportResult exportResult = ServerManager.readObjectFromResponse((ResponseEntity<? extends Serializable>)response, ExportResult.class);
            superplan.setRevision(exportResult.getRevision());
            return exportResult;
        }
        catch (Exception x) {
            log.error(x.getMessage(), x);
            throw new ExportException(x);
        }
    }

    private static String readStringFromResponse(ResponseEntity<byte[]> response) throws Exception {
        byte[] array = ServerManager.readObjectFromResponse(response, byte[].class);
        return new String(array, "utf-8");
    }

    private static <E> E readObjectFromResponse(ResponseEntity<? extends Serializable> response, Class<E> cls) throws Exception {
        switch (response.getStatusCode()) {
            case OK: {
                log.debug("Reading object from the response body...");
                try {
                    return cls.cast(response.getBody());
                }
                catch (ClassCastException x) {
                    log.error("Invalid object type accepted ({}).", (Object)((Serializable)response.getBody()).getClass().getName());
                    throw new IllegalStateException(String.format("Invalid object type accepted: %s", ((Serializable)response.getBody()).getClass().getName()));
                }
            }
            case METHOD_FAILURE: {
                Serializable errorb = (Serializable)response.getBody();
                if (errorb instanceof Exception) {
                    log.error("Exception accepted: {}", (Object)errorb);
                    throw (Exception)errorb;
                }
                log.error("No exception details available.");
                throw new IllegalStateException("No exception details available.");
            }
        }
        log.warn("Invalid response code {}.", (Object)response.getStatusCode().value());
        throw new IllegalStateException(String.format("Invalid response code %d.", response.getStatusCode().value()));
    }

    private static String createApiUrl(String command) {
        String prefix = ApplicationProperties.getProperty("server_url");
        Preconditions.checkNotNull(prefix);
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (prefix.endsWith("/api")) {
            prefix = prefix.substring(0, prefix.length() - "/api".length());
        }
        return prefix + "/api" + command;
    }

    public static void setCredentials(String username, String password) {
        REST.setRequestFactory(requestFactoryConfigurator.getAuthenticatedRequestFactory(username, password));
    }

    static {
        ConfPlanMessageConverter czbyte = new ConfPlanMessageConverter();
        ByteArrayHttpMessageConverter cbyte = new ByteArrayHttpMessageConverter();
        StringHttpMessageConverter cstring = new StringHttpMessageConverter();
        FormHttpMessageConverter cform = new FormHttpMessageConverter();
        SerializingMessageConverter cobject = new SerializingMessageConverter();
        List<HttpMessageConverter> list1 = Arrays.asList(new HttpMessageConverter[]{czbyte, cbyte, cstring, cobject});
        cform.setPartConverters(list1);
        List<HttpMessageConverter> list2 = Arrays.asList(new HttpMessageConverter[]{czbyte, cbyte, cstring, cform, cobject});
        REST.setMessageConverters(list2);
        REST.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            protected boolean hasError(HttpStatus statusCode) {
                return !HttpStatus.METHOD_FAILURE.equals((Object)statusCode) && super.hasError(statusCode);
            }
        });
        REST.setRequestFactory(requestFactoryConfigurator.getAuthenticatedRequestFactory(null, null));
    }

    private static class RequestFactoryConfigurator {
        private RequestFactoryConfigurator() {
        }

        private static SSLConnectionSocketFactory createSslConnectionSocketFactory() {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                ctx.init(null, new TrustManager[]{tm}, null);
                return new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (Exception ex) {
                log.error("Cannot create HTTP client that is able to connect to untrusted HTTPS servers.");
                return null;
            }
        }

        private static Proxy detectProxy() {
            System.setProperty("java.net.useSystemProxies", "true");
            try {
                Proxy proxy;
                URI baseUri = new URI(ServerManager.createApiUrl(""));
                if (baseUri.getScheme() != null && baseUri.getHost() != null && (proxy = ProxySelector.getDefault().select(baseUri).get(0)).type() != Proxy.Type.DIRECT) {
                    return proxy;
                }
            }
            catch (URISyntaxException e) {
                log.warn("Invalid API URL {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                log.warn("Cannot determine proxy settings. {}", (Object)e.getMessage());
            }
            return null;
        }

        private static HttpRequestInterceptor createGzipRequestInterceptor() {
            return new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip,deflate");
                    }
                }
            };
        }

        private static HttpResponseInterceptor createGzipResponseInterceptor() {
            return new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    HttpEntity entity = response.getEntity();
                    Header ceHeader = entity.getContentEncoding();
                    if (ceHeader != null) {
                        HeaderElement[] codecs;
                        for (HeaderElement codec : codecs = ceHeader.getElements()) {
                            if (!codec.getName().equalsIgnoreCase("gzip")) continue;
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                    }
                }
            };
        }

        private static void configurePlantuneUserCreds(CredentialsProvider credentialsProvider, String username, String password) {
            if (username != null && password != null) {
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            }
        }

        private static void configureProxyUserCreds(CredentialsProvider credentialsProvider, Proxy proxy) {
            String proxyUser = System.getProperty(ServerManager.PROXY_USER_PROPERTY);
            String proxyPassword = System.getProperty(ServerManager.PROXY_PASSWORD_PROPERTY);
            log.info("Proxy user: {} Proxy pass: {}", (Object)proxyUser, (Object)(proxyPassword != null ? 1 : 0));
            try {
                if (proxyUser != null && proxyPassword != null) {
                    InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
                    credentialsProvider.setCredentials(new AuthScope(proxyAddress.getHostString(), proxyAddress.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                    credentialsProvider.setCredentials(new AuthScope(proxyAddress.getAddress().getHostAddress(), proxyAddress.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                }
            }
            catch (Exception e) {
                log.error("Failed to configure proxy credentials.", e);
            }
        }

        protected ClientHttpRequestFactory getAuthenticatedRequestFactory(String username, String password) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            DefaultSchemePortResolver schemePortResolver = new DefaultSchemePortResolver();
            RegistryBuilder regBob = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            SSLConnectionSocketFactory sslCsf = RequestFactoryConfigurator.createSslConnectionSocketFactory();
            if (sslCsf != null) {
                regBob.register("https", (Object)sslCsf);
            }
            Registry sfReg = regBob.build();
            Registry authProviders = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory(Charsets.UTF_8)).build();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setSchemePortResolver((SchemePortResolver)schemePortResolver);
            clientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(sfReg));
            clientBuilder.addInterceptorLast(RequestFactoryConfigurator.createGzipRequestInterceptor());
            clientBuilder.addInterceptorLast(RequestFactoryConfigurator.createGzipResponseInterceptor());
            clientBuilder.setDefaultAuthSchemeRegistry((Lookup)authProviders);
            RequestFactoryConfigurator.configurePlantuneUserCreds((CredentialsProvider)credentialsProvider, username, password);
            Proxy proxy = RequestFactoryConfigurator.detectProxy();
            if (proxy != null) {
                log.info("Using proxy {}", (Object)proxy);
                RequestFactoryConfigurator.configureProxyUserCreds((CredentialsProvider)credentialsProvider, proxy);
                clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner((SchemePortResolver)schemePortResolver, ProxySelector.getDefault()));
            }
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return new HttpComponentsClientHttpRequestFactory((HttpClient)clientBuilder.build());
        }
    }
}

